# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from enum import Enum
from .sdpackagemgr import SDPackageMgr
from .sdmodulemgr import SDModuleMgr
from .sdgraphdefinitionmgr import SDGraphDefinitionMgr
from .sduimgr import SDUIMgr
from .sdpluginmgr import SDPluginMgr
from .sdcolormanagementengine import SDColorManagementEngine
from .sdspotcolorlibrary import SDSpotColorLibrary
from .sdappinteropmgr import SDAppInteropMgr
from .sdapiobject import SDAPIObject
from .sdapiobject import SDApiError
from .apiexception import APIException

class SDApplicationPath(Enum):
    """
    Enum representing predefined paths
    """
    """The directory where the application is installed"""
    InstallationDir = 0
    """The directory where the default library is installed"""
    DefaultResourcesDir = 1
    """The default directory used for temporary files"""
    DefaultTemporaryDir = 2

class SDApplication(SDAPIObject):
    """
    Root object of all objects managed by the API
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDApplication
        """
        super(SDApplication, self).__init__(APIContext, handle, *args, **kwargs)
        # Manually written code patched in by IPA begins
        self.mContext = APIContext
        # Create new SD application
        handle = ctypes.c_void_p()
        res = self.mContext.getCTypesFct('CApi_getSDApplication')(ctypes.byref(handle))
        if res != 0:
            raise Exception('Fail to initialize SD Application')
        self.mHandle = handle

        # App callbacks
        dllHandle = self.mContext.mDllHandle
        self.__registerBeforeFileLoadedCallback = dllHandle.registerBeforeFileLoadedAppCallback
        self.__registerAfterFileLoadedCallback = dllHandle.registerAfterFileLoadedAppCallback
        self.__registerBeforeFileSavedCallback = dllHandle.registerBeforeFileSavedAppCallback
        self.__registerAfterFileSavedCallback = dllHandle.registerAfterFileSavedAppCallback
        self.__registerBeforeFileClosedCallback = dllHandle.registerBeforeFileClosedAppCallback
        self.__registerAfterFileClosedCallback = dllHandle.registerAfterFileClosedAppCallback
        self.__unregisterCallback = dllHandle.unregisterAppCallback

        from .sdcallbackmap import SDCallbackMap
        self.__callbackMap = SDCallbackMap
        # Manually written code patched in by IPA ends

    def getPackageMgr(self) -> Optional[SDPackageMgr]:
        """
        Get the Package Manager

        """
        outPackageManager = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getPackageMgr(self.mHandle, ctypes.byref(outPackageManager))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPackageManager, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPackageManager.value, ownHandle=True)

    def getModuleMgr(self) -> SDModuleMgr:
        """
        Get the Module Manager

        """
        outSDModuleMgr = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getModuleMgr(self.mHandle, ctypes.byref(outSDModuleMgr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDModuleMgr, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDModuleMgr.value, ownHandle=True)

    def getSDGraphDefinitionMgr(self) -> SDGraphDefinitionMgr:
        """
        Get the Graph Definition Mgr

        """
        outSDGraphDefinitionMgr = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getSDGraphDefinitionMgr(self.mHandle, ctypes.byref(outSDGraphDefinitionMgr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDGraphDefinitionMgr, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDGraphDefinitionMgr.value, ownHandle=True)

    def getPath(self, sdApplicationPath : SDApplicationPath) -> str:
        """
        Get the path specified by the SDApplicationPath enum

        :param sdApplicationPath: The enum representing the path to get
        """
        outPath = ctypes.c_char_p()
        _res = self.mAPIContext.SDApplication_getPath(self.mHandle, sdApplicationPath.value, ctypes.byref(outPath))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outPath.value.decode('utf-8') # type: ignore

    def getUIMgr(self) -> Optional[SDUIMgr]:
        """
        Get the UI Manager

        """
        outUIManager = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getUIMgr(self.mHandle, ctypes.byref(outUIManager))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outUIManager, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outUIManager.value, ownHandle=True)

    def getPluginMgr(self) -> SDPluginMgr:
        """
        Get the Plugin Manager

        """
        outPluginManager = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getPluginMgr(self.mHandle, ctypes.byref(outPluginManager))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outPluginManager, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outPluginManager.value, ownHandle=True)

    def getColorManagementEngine(self) -> Optional[SDColorManagementEngine]:
        """
        Get the Color Management Engine

        """
        outColorManagementEngine = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getColorManagementEngine(self.mHandle, ctypes.byref(outColorManagementEngine))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outColorManagementEngine, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outColorManagementEngine.value, ownHandle=True)

    def getSpotColorLibrary(self) -> Optional[SDSpotColorLibrary]:
        """
        Get the Spot Color Library

        """
        outSpotColorLibrary = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getSpotColorLibrary(self.mHandle, ctypes.byref(outSpotColorLibrary))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSpotColorLibrary, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSpotColorLibrary.value, ownHandle=True)

    def getAppInteropMgr(self) -> Optional[SDAppInteropMgr]:
        """

        """
        outAppInteropMgr = ctypes.c_void_p()
        _res = self.mAPIContext.SDApplication_getAppInteropMgr(self.mHandle, ctypes.byref(outAppInteropMgr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outAppInteropMgr, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outAppInteropMgr.value, ownHandle=True)

    def getVersion(self) -> str:
        """
        Get the application version as "MAJOR.MINOR.PATCH"

        """
        outVersionStr = ctypes.c_char_p()
        _res = self.mAPIContext.SDApplication_getVersion(self.mHandle, ctypes.byref(outVersionStr))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outVersionStr.value.decode('utf-8') # type: ignore
    # Manually written code patched in by IPA begins
    def getQtForPythonUIMgr(self):
       """ return ..."""
       uiMgr = self.getUIMgr()

       if uiMgr:
           from .qtforpythonuimgrwrapper import QtForPythonUIMgrWrapper
           return QtForPythonUIMgrWrapper(uiMgr)

       return None

    # App callbacks
    def registerBeforeFileLoadedCallback(self, callable):
        """
        Register a callback to be called before a file is loaded
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call before a file is loaded
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_char_p)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerBeforeFileLoadedCallback)

    def registerAfterFileLoadedCallback(self, callable):
        """
        Register a callback to be called after a file is loaded
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call after a file is loaded
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_char_p, ctypes.c_bool, ctypes.c_bool)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerAfterFileLoadedCallback)

    def registerBeforeFileSavedCallback(self, callable):
        """
        Register a callback to be called before a file is saved
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call before a file is saved
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_char_p, ctypes.c_char_p)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerBeforeFileSavedCallback)

    def registerAfterFileSavedCallback(self, callable):
        """
        Register a callback to be called after a file is saved
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call after a file is saved
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_char_p, ctypes.c_bool)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerAfterFileSavedCallback)

    def registerBeforeFileClosedCallback(self, callable):
        """
        Register a callback to be called before a file is closed
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call before a file is closed
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_char_p)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerBeforeFileClosedCallback)

    def registerAfterFileClosedCallback(self, callable):
        """
        Register a callback to be called after a file is closed
        Returns a callback ID that can be used later to unregister the callback

        :param callable: Function to call after a file is closed
        :type callable: Python function
        :rtype: int
        """
        functionType = ctypes.CFUNCTYPE(None, ctypes.c_char_p, ctypes.c_bool)
        f = functionType(callable)
        return self.__callbackMap._registerCallback(f, self.__registerAfterFileClosedCallback)

    def unregisterCallback(self, callbackID):
        """
        Unregister a callback

        :param callbackID: The callback ID of the callback to unregister
        :type callbackID: int
        :rtype: None
        """
        self.__callbackMap._unregisterCallback(callbackID, self.__unregisterCallback)

    # Manually written code patched in by IPA ends

